/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher;

import com.oxaion.tools.weblauncher.LauncherWindow;
import com.oxaion.tools.weblauncher.data.Configuration;
import com.oxaion.tools.weblauncher.data.File;
import com.oxaion.tools.weblauncher.data.FileSystemWrapper;
import com.oxaion.tools.weblauncher.data.Folder;
import com.oxaion.tools.weblauncher.xml.ConfigurationParser;
import com.oxaion.tools.weblauncher.xml.FileVersionParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.xml.sax.InputSource;

public class UpdateTask
extends Thread {
    private static final Logger log = Logger.getLogger(UpdateTask.class.getName());
    private static final String INSTALLEDVERSION_XML = "installedversion.xml";
    private LauncherWindow progressIndicator;
    private Configuration config;
    private String os;
    private ResourceBundle languageBundle = null;
    private String[] additionalArguments;
    private String cachedVersionList;
    private HttpClient client = HttpClient.newHttpClient();

    public UpdateTask(LauncherWindow progressIndicator, Configuration baseConfig, String[] additionalArguments) {
        this.config = baseConfig;
        this.progressIndicator = progressIndicator;
        this.additionalArguments = additionalArguments;
        this.os = System.getProperty("os.name");
    }

    @Override
    public void run() {
        try {
            this.languageBundle = ResourceBundle.getBundle("com.oxaion.tools.weblauncher.Main");
        }
        catch (MissingResourceException e) {
            this.languageBundle = null;
        }
        if (this.languageBundle == null) {
            try {
                this.languageBundle = ResourceBundle.getBundle("com.oxaion.tools.weblauncher.Main", Locale.ENGLISH);
            }
            catch (MissingResourceException e) {
                this.languageBundle = null;
            }
        }
        try {
            this.progressIndicator.setIndeterminate(true);
            this.loadConfiguration(this.additionalArguments);
            String lang = this.config.getLanguage();
            if (lang == null) {
                lang = "de";
            }
            try {
                this.languageBundle = ResourceBundle.getBundle("com.oxaion.tools.weblauncher.Main", new Locale(lang));
            }
            catch (MissingResourceException e) {
                this.languageBundle = null;
            }
            if (this.languageBundle == null) {
                try {
                    this.languageBundle = ResourceBundle.getBundle("com.oxaion.tools.weblauncher.Main", Locale.ENGLISH);
                }
                catch (MissingResourceException e) {
                    this.languageBundle = null;
                }
            }
            this.progressIndicator.setStatusText(this.languageBundle.getString("load_config"));
            Folder oldVersionList = this.getInstalledVersionList();
            Folder newVersionList = this.getCurrentVersionList();
            this.progressIndicator.setStatusText(this.languageBundle.getString("find_updates"));
            List<File> files2Update = newVersionList.findFilesToUpdate(oldVersionList);
            List<FileSystemWrapper> deletes = oldVersionList.findFilesToDelete(newVersionList);
            java.io.File fPathCandidate = new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath());
            if (fPathCandidate.exists() && !fPathCandidate.canWrite()) {
                throw new RuntimeException("Missing write permission for '" + fPathCandidate + "'");
            }
            if (!fPathCandidate.exists() && !fPathCandidate.mkdirs()) {
                throw new RuntimeException("Cannot create '" + fPathCandidate + "'");
            }
            this.progressIndicator.setStatusText(this.languageBundle.getString("download_files"));
            this.progressIndicator.setMaximum(this.getTotalDownloadSize(files2Update));
            this.progressIndicator.setIndeterminate(false);
            this.progressIndicator.setToolTipText(this.config.getOSConfiguration(this.os, false).getInstallationPath());
            for (File file : files2Update) {
                if (file == null) continue;
                this.downloadFile(file);
            }
            this.progressIndicator.setIndeterminate(true);
            this.progressIndicator.setStatusText(this.languageBundle.getString("write_new_list"));
            this.writeNewVersionList();
            this.progressIndicator.setStatusText(this.languageBundle.getString("delete_files"));
            this.deleteFiles(deletes);
        }
        catch (UpdateStoppedException e) {
            int result = this.showProceedWithLaunchDialog(e);
            if (result == 1) {
                this.progressIndicator.exit(8);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.progressIndicator.showMessageDialog(e.getMessage(), "Error: ", 0);
            this.progressIndicator.exit(1);
            return;
        }
        this.progressIndicator.setStatusText(this.languageBundle.getString("start_app"));
        this.launchApplication();
    }

    private long getTotalDownloadSize(List<File> files) {
        long size = 0L;
        for (File file : files) {
            size += file.getSize();
        }
        return size;
    }

    private int showProceedWithLaunchDialog(UpdateStoppedException e) {
        System.err.println(e.getLocalizedMessage());
        e.printStackTrace();
        log.log(Level.SEVERE, e.getLocalizedMessage(), e);
        Object message = new String();
        switch (e.getType()) {
            case 5: {
                message = e.getInformation();
                break;
            }
            case 0: {
                message = this.languageBundle.getString("connection_error");
                break;
            }
            case 3: {
                message = this.languageBundle.getString("io_error1") + e.getInformation() + this.languageBundle.getString("io_error2");
                break;
            }
            case 4: {
                message = this.languageBundle.getString("config_io_error");
                break;
            }
            case 1: {
                message = this.languageBundle.getString("file_error1") + e.getInformation() + this.languageBundle.getString("file_error2");
            }
        }
        message = (String)message + this.languageBundle.getString("update_error_message");
        return this.progressIndicator.showConfirmDialog((String)message, this.languageBundle.getString("update_error_title"), 0, 3);
    }

    private void loadConfiguration(String[] additionalArguments) {
        String configFileContent = null;
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.config.getProtocol() + "://" + this.config.getHost() + ":" + this.config.getPort() + this.config.getBasePath() + this.config.getConfigFileName())).build();
            configFileContent = this.client.send(request, HttpResponse.BodyHandlers.ofString()).body();
            new ConfigurationParser().parse(new InputSource(new StringReader(configFileContent)), this.config, additionalArguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loadLocalConfiguration(additionalArguments);
        }
        if (configFileContent == null || this.config == null) {
            return;
        }
        if (this.config.getOSConfiguration(this.os, false) == null) {
            this.progressIndicator.showMessageDialog(this.config.getConfigFileName() + "\n" + String.format(this.languageBundle.getString("fatal_config_os_error"), this.os), this.languageBundle.getString("update_error_title"), 0);
            this.progressIndicator.exit(42);
            return;
        }
        try {
            java.io.File configFile = new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath(), this.config.getConfigFileName());
            configFile.getParentFile().mkdirs();
            FileWriter toFile = new FileWriter(configFile);
            toFile.write(configFileContent);
            toFile.flush();
            toFile.close();
            java.io.File fConfig = new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath(), this.config.getConfigFileName());
            Preferences.userNodeForPackage(this.getClass()).put(this.config.getUniqueIdentifier(), fConfig.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadLocalConfiguration(String[] additionalArguments) {
        String configPath = "";
        try {
            configPath = Preferences.userNodeForPackage(this.getClass()).get(this.config.getUniqueIdentifier(), null);
            if (configPath != null) {
                new ConfigurationParser().parse(new InputSource(new FileInputStream(configPath)), this.config, additionalArguments);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.progressIndicator.showMessageDialog(configPath + "\n" + this.languageBundle.getString("fatal_config_error"), this.languageBundle.getString("update_error_title"), 0);
            this.progressIndicator.exit(41);
        }
    }

    private Folder getInstalledVersionList() throws UpdateStoppedException {
        Folder folder;
        FileInputStream fis = new FileInputStream(new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath(), INSTALLEDVERSION_XML));
        try {
            folder = new FileVersionParser().parse(new InputSource(fis));
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return new Folder();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UpdateStoppedException(4, e.getMessage(), e);
            }
        }
        fis.close();
        return folder;
    }

    private void writeNewVersionList() throws UpdateStoppedException {
        try {
            java.io.File fInstalledVersionXml = new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath(), INSTALLEDVERSION_XML);
            FileWriter writer = new FileWriter(fInstalledVersionXml);
            writer.write(this.cachedVersionList.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.log(Level.WARNING, "writeNewVersionList caught {0}", e);
            throw new UpdateStoppedException(3, "installedversion.xml\n" + e.getMessage(), e);
        }
    }

    private Folder getCurrentVersionList() throws UpdateStoppedException {
        try {
            URI uri = URI.create(this.config.getProtocol() + "://" + this.config.getHost() + ":" + this.config.getPort() + this.config.getBasePath() + this.config.getVersionFile() + "?os=" + URLEncoder.encode(System.getProperty("os.name"), "UTF-8"));
            URLConnection connection = uri.toURL().openConnection();
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = null;
            this.cachedVersionList = "";
            StringBuilder b = new StringBuilder();
            while ((line = in.readLine()) != null) {
                b.append(line);
            }
            in.close();
            this.cachedVersionList = b.toString();
            Folder versionList = new FileVersionParser().parse(new InputSource(new StringReader(this.cachedVersionList)));
            return versionList;
        }
        catch (UnknownHostException e) {
            throw new UpdateStoppedException(0, new String(), e);
        }
        catch (Exception e) {
            throw new UpdateStoppedException(4, this.config.getVersionFile(), e);
        }
    }

    private void downloadFile(File file) throws UpdateStoppedException {
        long time = System.currentTimeMillis();
        System.out.print(file.getPath());
        this.progressIndicator.startDownload(file);
        try {
            int bytesRead;
            FileOutputStream toFile;
            java.io.File receivedFile;
            InputStream input;
            block10: {
                HttpRequest request = HttpRequest.newBuilder().uri(new URI(this.config.getProtocol(), null, this.config.getHost(), this.config.getPort(), this.config.getBasePath() + file.getPath(), null, null)).build();
                input = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream()).body();
                receivedFile = new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath(), file.getPath());
                if (receivedFile.getName().endsWith(".jar") && UpdateTask.isFileLocked(receivedFile)) {
                    java.io.File fNewLibs = new java.io.File(receivedFile.getParentFile(), "new-libs");
                    receivedFile = new java.io.File(fNewLibs, receivedFile.getName());
                }
                receivedFile.getParentFile().mkdirs();
                toFile = null;
                try {
                    toFile = new FileOutputStream(receivedFile);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    if (receivedFile.canWrite()) break block10;
                    java.io.File testFile = receivedFile.getParentFile();
                    java.io.File problemFile = null;
                    while (testFile != null && !testFile.canWrite()) {
                        problemFile = testFile = testFile.getParentFile();
                    }
                    if (problemFile == null) {
                        problemFile = receivedFile;
                    }
                    throw new UpdateStoppedException(5, this.languageBundle.getString("no_write_permission") + "\n" + problemFile.getAbsolutePath(), e);
                }
            }
            byte[] buffer = new byte[1024];
            long progress = this.progressIndicator.getValue();
            while ((bytesRead = input.read(buffer)) != -1) {
                toFile.write(buffer, 0, bytesRead);
                this.progressIndicator.setValue(progress += (long)bytesRead);
            }
            toFile.close();
            System.out.println("\t" + receivedFile.length() / 1024L + "\t" + (System.currentTimeMillis() - time));
        }
        catch (InterruptedException | UnknownHostException e) {
            throw new UpdateStoppedException(0, new String(), e);
        }
        catch (IOException e) {
            throw new UpdateStoppedException(1, file.getName(), e);
        }
        catch (URISyntaxException e) {
            throw new UpdateStoppedException(3, file.getName(), e);
        }
    }

    private void deleteFiles(List<FileSystemWrapper> filesToDelete) {
        for (FileSystemWrapper file : filesToDelete) {
            java.io.File realFile = new java.io.File(this.config.getOSConfiguration(this.os, false).getInstallationPath(), file.getPath());
            if (!realFile.exists()) continue;
            try {
                Files.walkFileTree(realFile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void launchApplication() {
        try {
            this.config.getOSConfiguration(this.os, false).runCommands();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.progressIndicator.showMessageDialog(this.languageBundle.getString("run_error_message") + "\n" + e.getMessage(), this.languageBundle.getString("run_error_title"), 0);
        }
        finally {
            this.progressIndicator.exit(0);
        }
    }

    private static boolean isFileLocked(java.io.File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            java.io.File tempFile = java.io.File.createTempFile(file.getName(), "lock-test", file.getParentFile());
            tempFile.delete();
            return !file.renameTo(tempFile) || !tempFile.renameTo(file);
        }
        catch (IOException e) {
            return true;
        }
    }

    private static class UpdateStoppedException
    extends Exception {
        private static final int CONNECTION_ERROR = 0;
        private static final int MISSING_FILE_ERROR = 1;
        private static final int IO_ERROR = 3;
        private static final int CONFIG_IO_ERROR = 4;
        private static final int NO_WRITE_PERMISSION = 5;
        private int type;
        private String info;

        public UpdateStoppedException(int type, String info, Throwable cause) {
            super(info, cause);
            this.type = type;
            this.info = info;
        }

        public int getType() {
            return this.type;
        }

        public String getInformation() {
            return this.info;
        }
    }
}

